###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mini_stream_mult_prdts_bof_may09.nasl 2345 2009-05-18 15:15:24Z may $
#
# Mini-Stream Multiple Products Stack Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900646);
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1642", "CVE-2009-1641", "CVE-2009-1645");
  script_bugtraq_id(34864);
  script_name("Mini-Stream Multiple Products Stack Overflow Vulnerability");
  desc = "

  Overview:
  This host has Mini-Stream products installed and is prone to Stack Overflow
  Vulnerability.

  Vulnerability Insight:
  Inadequate boundary checks error of user supplied input to Mini-stream products
  which causes stack overflow while processing .ram and .asx files with overly
  long URIs.

  Impact:
  Successful exploitation will let the attacker craft malicious 'asx' or 'ram'
  files and execute arbitrary codes to cause stack overflow in the context of
  the affected application.

  Impact Level: Application

  Affected Software/OS:
  Ripper version 3.0.1.1 (3.0.1.5) and prior
  RM-MP3 Converter version 3.0.0.7 and prior
  ASXtoMP3 Converter version 3.0.0.7 and prior

  Fix: No solution or patch is available as on 26th May,2009. Information
  regarding This issue will be updated once the solution details are available.
  For updates refer,http://www.mini-stream.net

  References:
  http://www.milw0rm.com/exploits/8629
  http://www.milw0rm.com/exploits/8630
  http://www.milw0rm.com/exploits/8633
  http://www.milw0rm.com/exploits/8632
  http://www.milw0rm.com/exploits/8631
  http://xforce.iss.net/xforce/xfdb/50374
  http://xforce.iss.net/xforce/xfdb/50375
  http://xforce.iss.net/xforce/xfdb/50376

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Mini Stream Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_mini_stream_prdts_detect.nasl");
  script_require_keys("MiniStream/RmToMp3/Conv/Ver",
                      "MiniStream/AsxToMp3/Conv/Ver", "MiniStream/Ripper/Ver");
  exit(0);
}


include("version_func.inc");

rmMp3 = get_kb_item("MiniStream/RmToMp3/Conv/Ver");
if(rmMp3)
{
  if(version_is_less_equal(version:rmMp3, test_version:"3.0.0.7"))
  {
    security_hole(0);
  }
}

asxMp3 = get_kb_item("MiniStream/AsxToMp3/Conv/Ver");
if(asxMp3)
{
  if(version_is_less_equal(version:asxMp3, test_version:"3.0.0.7"))
  {
    security_hole(0);
  }
}

ripper = get_kb_item("MiniStream/Ripper/Ver");
if(ripper)
{
  #Ministream ripper 3.0.1.1 points to the version 3.0.1.5
  if(version_is_less_equal(version:ripper,test_version:"3.0.1.5"))
  {
    security_hole(0);
  }
}
