##############################################################################
#
#  OpenVPN Client Remote Code Execution Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/08
#
#  Revision: 1.3 
#
#  Log: schandan
#  Issue #0095
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900024);
 script_bugtraq_id(30532);
 script_cve_id("CVE-2008-3459");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.3 ");
 script_tag(name:"cvss_base", value:"6.0");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("OpenVPN Client Remote Code Execution Vulnerability");
 summary = "Check for vulnerable version of OpenVPN";
 script_summary("Check for vulnerable version of OpenVPN");
 desc = "
 Overview : The host is running OpenVPN Client, which is prone to remote code
 execution vulnerability.

 Vulnerability Insight:

        Application fails to properly validate the specially crafted input
        passed to lladdr/iproute configuration directives.

        Impact : Remote attackers could execute arbitrary code on the Client.

        Successful exploitation requires,
        - the client to agree to allow the server to push configuration
          directives to it by including pull or the macro client in its
          configuration file.
        - the client successfully authenticates the server.
        - the server is malicious and has been compromised under the control
          of the attacker.

 Impact Level : Application/System

 Affected Software/OS :
        Non-Windows OpenVPN client OpenVPN 2.1-beta14 to OpenVPN 2.1-rc8

 Fix : Upgrade to higher version of Non-Windows OpenVPN client OpenVPN 2.1-rc9
 http://openvpn.net/index.php/downloads.html

 References : http://www.frsirt.com/english/advisories/2008/2316
 http://openvpn.net/index.php/documentation/change-log/changelog-21.html

 CVSS Score :
        CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
        CVSS Temporal Score : 4.4
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");
 
 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }


 foreach item (get_kb_list("ssh/*/rpms"))
 {
        if("openvpn~" >< item)
        {
		# Grep for openvpn 2.1-beta14 to 2.1-rc8
                if(egrep(pattern:"^openvpn~2.1~.*(beta14|rc[0-8])($|[^0-9])",
			 string:item)){
                        security_hole(0);
                }
                exit(0);
        }
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
        exit(0);
 }
 
 vpnVer = ssh_cmd(socket:sock, cmd:"openvpn --version", timeout:timeout);
 ssh_close_connection();
 
 if(!vpnVer){
        exit(0);
 }

 # Grep for openvpn 2.1-beta14 to 2.1-rc8
 if(egrep(pattern:"OpenVPN 2.1_(beta14|rc[0-8])($|[^.0-9])", string:vpnVer)){
        security_hole(0);
 }
