###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_sec_bypass_n_file_write_vuln_900184.nasl 720 2008-12-25 14:29:24Z dec $
#
# PHP Security Bypass and File Writing Vulnerability - Dec08
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900184);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5624", "CVE-2008-5625", "CVE-2008-5658");
  script_bugtraq_id(32383, 32625, 32688);
  script_name("PHP Security Bypass and File Writing Vulnerability - Dec08");
  desc = "

  Overview: The host is running PHP and is prone to Security Bypass and File
  Writing vulnerability.

  Vulnerability Insight:
  The flaw is caused due to,
  - An error in initialization of 'page_uid' and 'page_gid' global variables
    for use by the SAPI 'php_getuid' function, which bypass the safe_mode
    restrictions.
  - When 'safe_mode' is enabled through a 'php_admin_flag' setting in
    'httpd.conf' file, which does not enforce the 'error_log', 'safe_mode
    restrictions.
  - In 'ZipArchive::extractTo' function which allows attacker to write files
    via a ZIP file.

  Impact:
  Successful exploitation could allow remote attackers to write arbitrary file,
  bypass security restrictions and cause directory traversal attacks.

  Impact Level: System/Application

  Affected Software/OS:
  PHP versions prior to 5.2.7.

  Fix: Upgrade to version 5.2.7 or later
  http://www.php.net/downloads.php

  References:
  http://www.php.net/ChangeLog-5.php#5.2.7
  http://www.php.net/archive/2008.php#id2008-12-07-1
  http://www.securityfocus.com/archive/1/archive/1/498985/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}
# Grep for version 5.x to 5.2.6
if(version_in_range(version:phpVer, test_version:"5.0", test_version2:"5.2.6")){
  security_hole(phpPort);
}
