###############################################################################
# OpenVAS Vulnerability Test
# $Id: zabbix_detect.nasl 7592 2010-05-07 14:44:11Z chandra $
#
# ZABBIX Server Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running a ZABBIX Server. Zabbix is an enterprise-class
open source distributed monitoring solution. 

See also:
http://www.zabbix.com

Risk factor : None";

if (description)
{
 script_id(100403);
 script_version ("1.0-$Revision: 7592 $");
 script_tag(name:"risk_factor", value:"None");

 script_name("ZABBIX Server Detection");
 script_description(desc);
 script_summary("Checks for the presence of ZABBIX Server");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/unknown", 10051);
 exit(0);
}

include("misc_func.inc");

port = 10051;
if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

req = string("ZBX_GET_HISTORY_LAST_ID");
send(socket:soc, data:req);

buf = recv(socket:soc, length:1024);
close(soc);

if(isnull(buf))exit(0);

if("ZBXD" >< buf) {
  register_service(port:port, ipproto:"tcp", proto:"zabbix_server");
  set_kb_item(name: string("cpe:/a:zabbix:zabbix"), value: TRUE);
  security_note(port:port);
  exit(0);
}

exit(0);
