#define _GNU_SOURCE
#include <stdio.h>
#include <string.h>
#include "cities.h"

static struct city_list {
	int region;
	const char *name;
} city_list[] = {
	{ 0,	"AGEN" },
	{ 0,	"AUCH" },
	{ 0,	"BORDEAUX" },
	{ 0,	"BRIVE LA GAILLARDE" },
	{ 0,	"CAHORS" },
	{ 0,	"MONTAUBAN" },
	{ 0,	"MONT MARSAN" },
	{ 0,	"PAU" },
	{ 0,	"PERIGUEUX" },
	{ 0,	"TARBES" },
	{ 0,	"TOULOUSE" },
	{ 1,	"ANGOULEME" },
	{ 1,	"LA ROCHELL" },
	{ 1,	"LA ROCHE S" },
	{ 1,	"LIMOGES" },
	{ 1,	"NIORT" },
	{ 1,	"POITIERS" },
	{ 2,	"ALENCON" },
	{ 2,	"AUXERRE" },
	{ 2,	"BAR LE DUC" },
	{ 2,	"BLOIS" },
	{ 2,	"BOBIGNY" },
	{ 2,	"BOURGES" },
	{ 2,	"CERGY PONT" },
	{ 2,	"CHARTRES" },
	{ 2,	"CRETEIL" },
	{ 2,	"EVRY" },
	{ 2,	"LE MANS" },
	{ 2,	"MELUN" },
	{ 2,	"NANTERRE" },
	{ 2,	"NEVERS" },
	{ 2,	"ORLEANS" },
	{ 2,	"PARIS" },
	{ 2,	"REIMS" },
	{ 2,	"TOURS" },
	{ 2,	"TROYES" },
	{ 2,	"VERSAILLES" },
	{ 3,	"ANGERS" },
	{ 3,	"BREST" },
	{ 3,	"CHERBOURG" },
	{ 3,	"JERSEY" },
	{ 3,	"LAVAL" },
	{ 3,	"LORIENT" },
	{ 3,	"NANTES" },
	{ 3,	"RENNES" },
	{ 3,	"ST BRIEUC" },
	{ 4,	"AURILLAC" },
	{ 4,	"CLERMON FERRAND" },
	{ 4,	"FLORAC" },
	{ 4,	"GUERET" },
	{ 4,	"MENDE" },
	{ 4,	"MILLAU" },
	{ 4,	"MONTLUCON" },
	{ 4,	"PUY VELAY" },
	{ 4,	"RODEZ" },
	{ 4,	"ST-ETIENNE" },
	{ 4,	"ST FLOUR" },
	{ 5,	"ALBI" },
	{ 5,	"BEZIERS" },
	{ 5,	"CARCASSONN" },
	{ 5,	"FOIX" },
	{ 5,	"MONTPELLIER" },
	{ 5,	"PERPIGNAN" },
	{ 6,	"AALST" },
	{ 6,	"ANTWERPEN" },
	{ 6,	"BOULOGNE" },
	{ 6,	"BRUGGE" },
	{ 6,	"BRUSSEL" },
	{ 6,	"CHARLEROI" },
	{ 6,	"GENK" },
	{ 6,	"GENT" },
	{ 6,	"HALLE" },
	{ 6,	"HASSELT" },
	{ 6,	"IXELLES" },
	{ 6,	"KNOKKE-HEIST" },
	{ 6,	"KORTRIJK" },
	{ 6,	"LEUVEN" },
	{ 6,	"LIEGE" },
	{ 6,	"LILLE" },
	{ 6,	"LOKEREN" },
	{ 6,	"MAASTRICHT" },
	{ 6,	"MECHELEN" },
	{ 6,	"MIDDELBURG" },
	{ 6,	"MONS" },
	{ 6,	"MOUSCRON" },
	{ 6,	"NAMUR" },
	{ 6,	"OOSTENDE" },
	{ 6,	"ROESELARE" },
	{ 6,	"SCHAERBEEK" },
	{ 6,	"TERNEUZEN" },
	{ 6,	"TOURNAI" },
	{ 7,	"CHAUMONT" },
	{ 7,	"DIJON" },
	{ 7,	"EPINAL" },
	{ 7,	"LONS LE S" },
	{ 7,	"METZ" },
	{ 7,	"NANCY" },
	{ 7,	"VESOUL" },
	{ 8,	"ALES" },
	{ 8,	"AVIGNON" },
	{ 8,	"MARSEILLE" },
	{ 8,	"MONTELIMAR" },
	{ 8,	"NIMES" },
	{ 8,	"PRIVAS" },
	{ 8,	"ST TROPEZ" },
	{ 8,	"TOULON" },
	{ 9,	"BOURG EN B" },
	{ 9,	"LYON" },
	{ 9,	"MACON" },
	{ 9,	"VALENCE" },
	{ 10,	"BRIANCON" },
	{ 10,	"CHAMBERY" },
	{ 10,	"DIGNE" },
	{ 10,	"GAP" },
	{ 10,	"GRENOBLE" },
	{ 11,	"ANNECY" },
	{ 11,	"BESANCON" },
	{ 11,	"DELEMONT" },
	{ 11,	"LA CHAUX-DE-FONDS" },
	{ 12,	"ASCHAFFENBURG" },
	{ 12,	"BAD HOMBURG" },
	{ 12,	"BAD KREUZNACH" },
	{ 12,	"DARMSTADT" },
	{ 12,	"FRANKFURT AM MAIN" },
	{ 12,	"HEIDELBERG" },
	{ 12,	"KAISERSLAUTERN" },
	{ 12,	"KARLSRUHE" },
	{ 12,	"LANDAU IN DER PFALZ" },
	{ 12,	"LUDWIGSHAFEN" },
	{ 12,	"MAINZ" },
	{ 12,	"MANNHEIM" },
	{ 12,	"PIRMASENS" },
	{ 12,	"WORMS" },
	{ 13,	"BITBURG" },
	{ 13,	"HAGEN" },
	{ 13,	"ISERLOHN" },
	{ 13,	"KOBLENZ" },
	{ 13,	"LUEDENSCHEID" },
	{ 13,	"LUXEMBOURG" },
	{ 13,	"NEUWIED" },
	{ 13,	"SAARBRUECKEN" },
	{ 13,	"SEDAN" },
	{ 13,	"SIEGEN" },
	{ 13,	"TRIER" },
	{ 13,	"VERVIERS" },
	{ 13,	"WIESBADEN" },
	{ 14,	"AACHEN" },
	{ 14,	"BIELEFELD" },
	{ 14,	"BOCHUM" },
	{ 14,	"BONN" },
	{ 14,	"DORTMUND" },
	{ 14,	"DUEREN" },
	{ 14,	"DUESSELDORF" },
	{ 14,	"DUISBURG" },
	{ 14,	"ESSEN" },
	{ 14,	"GELSENKIRCHEN" },
	{ 14,	"GUETERSLOH" },
	{ 14,	"KOELN" },
	{ 14,	"LINGEN" },
	{ 14,	"LIPPSTADT" },
	{ 14,	"MOENCHENGLADBACH" },
	{ 14,	"MUELHEIM AN DER RUHR" },
	{ 14,	"MUENSTER" },
	{ 14,	"NORDHORN" },
	{ 14,	"OBERHAUSEN" },
	{ 14,	"OSNABRUECK" },
	{ 14,	"RECKLINGHAUSEN" },
	{ 14,	"RHEINE" },
	{ 14,	"SOLINGEN" },
	{ 14,	"WESEL" },
	{ 14,	"WUPPERTAL" },
	{ 15,	"BRISTOL" },
	{ 15,	"CARDIFF" },
	{ 15,	"EXETER" },
	{ 15,	"HOLYHEAD" },
	{ 15,	"PLYMOUTH" },
	{ 15,	"ST DAVIDS" },
	{ 15,	"SWANSEA" },
	{ 16,	"BIRMINGHAM" },
	{ 16,	"BLACKPOOL" },
	{ 16,	"LEEDS" },
	{ 16,	"LEICESTER" },
	{ 16,	"LIVERPOOL" },
	{ 16,	"MANCHESTER" },
	{ 16,	"MIDDLESBROUGH" },
	{ 16,	"NEWCASTLE" },
	{ 16,	"NOTTINGHAM" },
	{ 16,	"SHEFFIELD" },
	{ 17,	"AMIENS" },
	{ 17,	"BEAUVAIS" },
	{ 17,	"CAEN" },
	{ 17,	"EVREUX" },
	{ 17,	"LAON" },
	{ 17,	"LE HAVRE" },
	{ 17,	"ROUEN" },
	{ 18,	"BOURNEMOUT" },
	{ 18,	"BRIGHTON" },
	{ 18,	"CAMBRIDGE" },
	{ 18,	"DOVER" },
	{ 18,	"IPSWICH" },
	{ 18,	"KINGSTON" },
	{ 18,	"LONDON" },
	{ 18,	"NORTHAMPTON" },
	{ 18,	"NORWICH" },
	{ 18,	"OXFORD" },
	{ 18,	"PORTSMOUTH" },
	{ 18,	"READING" },
	{ 18,	"SOUTHAMPTON" },
	{ 19,	"BORKUM" },
	{ 19,	"BREMERHAVEN" },
	{ 19,	"CUXHAVEN" },
	{ 19,	"DEN HELDER" },
	{ 19,	"ELMSHORN" },
	{ 19,	"EMDEN" },
	{ 19,	"GRONINGEN" },
	{ 19,	"HAMBURG" },
	{ 19,	"LEEUWARDEN" },
	{ 19,	"NORDERTSTEDT" },
	{ 19,	"SPIEKEROOG" },
	{ 19,	"ST PETER ORDING" },
	{ 19,	"SYLT" },
	{ 19,	"TEXEL" },
	{ 19,	"WILHELMSHAVEN" },
	{ 20,	"ALBORG" },
	{ 20,	"ESBJERG" },
	{ 20,	"FREDERIKSHAVN" },
	{ 20,	"HERNING" },
	{ 20,	"HOLSTERBRO" },
	{ 20,	"SKAGEN" },
	{ 20,	"THISTED" },
	{ 20,	"THYBOROEN" },
	{ 20,	"VIBORG" },
	{ 21,	"ARHUS" },
	{ 21,	"FREDERICIA" },
	{ 21,	"HORSENS" },
	{ 21,	"KOLDING" },
	{ 21,	"ODENSE" },
	{ 21,	"RANDERS" },
	{ 21,	"SILKEBORG" },
	{ 21,	"VEJLE" },
	{ 22,	"BRAUNSCHWEIG" },
	{ 22,	"BREMEN" },
	{ 22,	"CELLE" },
	{ 22,	"GOSLAR" },
	{ 22,	"HAMELN" },
	{ 22,	"HANNOVER" },
	{ 22,	"HERFORD" },
	{ 22,	"HILDESHEIM" },
	{ 22,	"LUENEBURG" },
	{ 22,	"MAGDEBURG" },
	{ 22,	"MINDEN" },
	{ 22,	"OLDENBURG" },
	{ 22,	"WOLFSBURG" },
	{ 23,	"HELSINGOER" },
	{ 23,	"KALUNDBORG" },
	{ 23,	"KOEBENHAVN" },
	{ 23,	"MALMOE" },
	{ 23,	"NAESTVED" },
	{ 23,	"ROSKILDE" },
	{ 23,	"SLAGELSE" },
	{ 24,	"FEHMARN" },
	{ 24,	"FLENSBURG" },
	{ 24,	"GREIFSWALD" },
	{ 24,	"KIEL" },
	{ 24,	"LUEBECK" },
	{ 24,	"ROSTOCK" },
	{ 24,	"RUEGEN" },
	{ 24,	"SCHWERIN" },
	{ 24,	"STRALSUND" },
	{ 24,	"SZCZECIN" },
	{ 24,	"WISMAR" },
	{ 25,	"AUGSBURG" },
	{ 25,	"DEGGENDORF" },
	{ 25,	"INGOLSTADT" },
	{ 25,	"LANDSHUT" },
	{ 25,	"PASSAU" },
	{ 25,	"REGENSBURG" },
	{ 25,	"ULM" },
	{ 26,	"BURGHAUSEN" },
	{ 26,	"FRIEDRICHSHAFEN" },
	{ 26,	"KEMPTEN" },
	{ 26,	"LINZ" },
	{ 26,	"MUENCHEN" },
	{ 26,	"ROSENHEIM" },
	{ 26,	"SIGMARINGEN" },
	{ 26,	"WELS" },
	{ 27,	"BOLZANO" },
	{ 27,	"MERANO" },
	{ 27,	"TRENTO" },
	{ 28,	"ANSBACH" },
	{ 28,	"BAMBERG" },
	{ 28,	"BAYREUTH" },
	{ 28,	"ERLANGEN" },
	{ 28,	"FUERTH" },
	{ 28,	"NUERNBERG" },
	{ 28,	"SCHWEINFURT" },
	{ 28,	"WEIDEN" },
	{ 28,	"WERTHEIM" },
	{ 28,	"WUERZBURG" },
	{ 29,	"ALTENBURG" },
	{ 29,	"BAUTZEN" },
	{ 29,	"CHEMNITZ" },
	{ 29,	"COTTBUS" },
	{ 29,	"DESSAU" },
	{ 29,	"DRESDEN" },
	{ 29,	"EISENHUETTENSTADT" },
	{ 29,	"GOERLITZ" },
	{ 29,	"HALLE" },
	{ 29,	"HOYERSWERDA" },
	{ 29,	"LEIPZIG" },
	{ 29,	"WITTENBERG" },
	{ 29,	"WROCLAW" },
	{ 30,	"EISENACH" },
	{ 30,	"ERFURT" },
	{ 30,	"GOTHA" },
	{ 30,	"HOF" },
	{ 30,	"JENA" },
	{ 30,	"NORDHAUSEN" },
	{ 30,	"PLAUEN" },
	{ 30,	"SUHL" },
	{ 30,	"WEIMAR" },
	{ 30,	"ZWICKAU" },
	{ 31,	"EVIAN" },
	{ 31,	"FRIBOURG" },
	{ 31,	"GENEVE" },
	{ 31,	"LAUSANNE" },
	{ 31,	"MONTREUX" },
	{ 31,	"NEUCHATEL" },
	{ 32,	"AARAU" },
	{ 32,	"BERN" },
	{ 32,	"BIENNE" },
	{ 32,	"FRAUENFELD" },
	{ 32,	"KONSTANZ" },
	{ 32,	"LUZERN" },
	{ 32,	"SCHAFFHAUSEN" },
	{ 32,	"SOLOTHURN" },
	{ 32,	"ZUERICH" },
	{ 32,	"ZUG" },
	{ 33,	"ADELBODEN" },
	{ 33,	"GRINDELWALD" },
	{ 33,	"INTERLAKEN" },
	{ 34,	"BRIG" },
	{ 34,	"MARTIGNY" },
	{ 34,	"SION" },
	{ 35,	"ALTDORF" },
	{ 35,	"GLARUS" },
	{ 35,	"SARNEN" },
	{ 35,	"SCHWYZ" },
	{ 35,	"STANS" },
	{ 35,	"ST.GALLEN" },
	{ 36,	"CHUR" },
	{ 36,	"DAVOS" },
	{ 37,	"FULDA" },
	{ 37,	"GIESSEN" },
	{ 37,	"GOETTINGEN" },
	{ 37,	"KASSEL" },
	{ 37,	"MARBURG" },
	{ 38,	"BELLINZONA" },
	{ 38,	"EDOLO" },
	{ 38,	"LOCARNO" },
	{ 38,	"LUGANO" },
	{ 39,	"AOSTA" },
	{ 39,	"SESTRIERE" },
	{ 40,	"ALESSANDRIA" },
	{ 40,	"BERGAMO" },
	{ 40,	"BRESCIA" },
	{ 40,	"MILANO" },
	{ 40,	"PARMA" },
	{ 40,	"PIACENZA" },
	{ 40,	"TORINO" },
	{ 40,	"VERONA" },
	{ 41,	"FIRENZE" },
	{ 41,	"PERUGIA" },
	{ 41,	"PISA" },
	{ 41,	"ROMA" },
	{ 41,	"SIENA" },
	{ 41,	"VATICANO" },
	{ 42,	"AMSTERDAM" },
	{ 42,	"ARNHEM" },
	{ 42,	"ASSEN" },
	{ 42,	"DEN HAAG" },
	{ 42,	"EINDHOVEN" },
	{ 42,	"HAARLEM" },
	{ 42,	"LELYSTAD" },
	{ 42,	"ROTTERDAM" },
	{ 42,	"S.HERTOGENBOSCH" },
	{ 42,	"UTRECHT" },
	{ 42,	"ZWOLLE" },
	{ 43,	"CANNES" },
	{ 43,	"GENOVA" },
	{ 43,	"LA SPEZIA" },
	{ 43,	"MONACO" },
	{ 43,	"NICE" },
	{ 43,	"SAN REMO" },
	{ 44,	"BOLOGNA" },
	{ 44,	"NOVA GORIC" },
	{ 44,	"RIJEKA" },
	{ 44,	"RIMINI" },
	{ 44,	"TRIESTE" },
	{ 44,	"UDINE" },
	{ 44,	"VENEZIA" },
	{ 45,	"BASEL" },
	{ 45,	"BELFORT" },
	{ 45,	"COLMAR" },
	{ 45,	"FREIBURG" },
	{ 45,	"LIESTAL" },
	{ 45,	"LOERRACH" },
	{ 45,	"MULHOUSE" },
	{ 45,	"OFFENBURG" },
	{ 45,	"STRASBOURG" },
	{ 46,	"GRAZ" },
	{ 46,	"KLAGENFURT" },
	{ 46,	"LIENZ" },
	{ 46,	"LJUBLJANA" },
	{ 46,	"MARIBOR" },
	{ 46,	"SEMMERING" },
	{ 46,	"VILLACH" },
	{ 46,	"ZELTWEG" },
	{ 47,	"BAD GASTEIN" },
	{ 47,	"INNSBRUCK" },
	{ 47,	"ISCHGL" },
	{ 47,	"LANDECK" },
	{ 47,	"SOELDEN" },
	{ 47,	"TUXERTAL" },
	{ 48,	"BAD TOELZ" },
	{ 48,	"BERCHTESGADEN" },
	{ 48,	"BISCHOFSHOFEN" },
	{ 48,	"BREGENZ" },
	{ 48,	"GARMISCH PARTENKIRCHEN" },
	{ 48,	"KITZBUEHEL" },
	{ 48,	"LINDAU" },
	{ 48,	"SALZBURG" },
	{ 48,	"SCHLADMING" },
	{ 48,	"STEYR" },
	{ 48,	"VADUZ" },
	{ 49,	"BRATISLAVA" },
	{ 49,	"EISENSTADT" },
	{ 49,	"GYOER" },
	{ 49,	"KLOSTERNEUBURG" },
	{ 49,	"SOPRON" },
	{ 49,	"SZOMBATHELY" },
	{ 49,	"TRENCIN" },
	{ 49,	"WIEN" },
	{ 49,	"WIENER NEUSTADT" },
	{ 49,	"ZALAEGERSZEG" },
	{ 50,	"BRNO" },
	{ 50,	"BUDEJOVICE" },
	{ 50,	"CHEB" },
	{ 50,	"HAVLICKAV BROD" },
	{ 50,	"HRADEC/KRA" },
	{ 50,	"JIHLAVA" },
	{ 50,	"KARLOVY VARY" },
	{ 50,	"KLADNO" },
	{ 50,	"MOST" },
	{ 50,	"OLOMOUC" },
	{ 50,	"OSTRAVA" },
	{ 50,	"PARDUBICE" },
	{ 50,	"PLZEN" },
	{ 50,	"PRAHA" },
	{ 50,	"PREROV" },
	{ 50,	"PROSTEJOV" },
	{ 50,	"ST POELTEN" },
	{ 50,	"ZWETTL" },
	{ 51,	"CHOMUTOV" },
	{ 51,	"DECIN" },
	{ 51,	"LIBEREC" },
	{ 51,	"OPAVA" },
	{ 51,	"PIRNA" },
	{ 51,	"SNIEZKA" },
	{ 51,	"TEPLICE" },
	{ 51,	"USTI NAD LABEM" },
	{ 51,	"WALBRZYCH" },
	{ 52,	"BERLIN" },
	{ 52,	"BRANDENBURG" },
	{ 52,	"FINOW" },
	{ 52,	"FRANKFURT AN DER ODER" },
	{ 52,	"GORZOW" },
	{ 52,	"NEUBRANDENBURG" },
	{ 52,	"POTSDAM" },
	{ 52,	"POZNAN" },
	{ 52,	"STENDAL" },
	{ 53,	"GOETEBORG" },
	{ 53,	"HALMSTAD" },
	{ 54,	"GAEVLE" },
	{ 54,	"NYKOPING" },
	{ 54,	"STOCKHOLM" },
	{ 54,	"UPPSALA" },
	{ 54,	"VAESTERAS" },
	{ 55,	"BORGHOLM" },
	{ 55,	"BORNHOLM" },
	{ 55,	"KALMAR" },
	{ 55,	"LINKOEPING" },
	{ 55,	"RONNE" },
	{ 55,	"VISBY" },
	{ 56,	"BORAS" },
	{ 56,	"JOENKOEPING" },
	{ 56,	"KARLSTAD" },
	{ 56,	"OEREBRO" },
	{ 57,	"BADEN-BADEN" },
	{ 57,	"DONAUESCHINGEN" },
	{ 57,	"FREUDENSTADT" },
	{ 57,	"VILLINGEN-SCHWENNINGEN" },
	{ 58,	"DRAMMEN" },
	{ 58,	"FREDRIKSTADEN" },
	{ 58,	"OSLO" },
	{ 58,	"TOENSBERG" },
	{ 59,	"AALEN" },
	{ 59,	"GOEPPINGEN" },
	{ 59,	"HEILBRONN" },
	{ 59,	"PFORZHEIM" },
	{ 59,	"REUTLINGEN" },
	{ 59,	"SCHWAEBISCH GMUEND" },
	{ 59,	"STUTTGART" },
	{ 59,	"TUEBINGEN" },
	{ 60,	"NAPOLI" },
	{ 61,	"ANCONA" },
	{ 61,	"PESCARA" },
	{ 61,	"SAN MARINO" },
	{ 62,	"BARI" },
	{ 62,	"FOGGIA" },
	{ 62,	"LECCE" },
	{ 63,	"BEKESCSABA" },
	{ 63,	"BRANSKA" },
	{ 63,	"BUDAPEST" },
	{ 63,	"DEBRECEN" },
	{ 63,	"DUNAIJVAROS" },
	{ 63,	"EGER" },
	{ 63,	"ERD" },
	{ 63,	"HODMEZOVASARHELY" },
	{ 63,	"KAPOSVAR" },
	{ 63,	"KECSKEMET" },
	{ 63,	"KOSICE" },
	{ 63,	"MISKOLC" },
	{ 63,	"NAGYKANIZSA" },
	{ 63,	"NYIREGYHAZA" },
	{ 63,	"OZD" },
	{ 63,	"PECS" },
	{ 63,	"SALGOTARJAN" },
	{ 63,	"SIOFOK" },
	{ 63,	"SZEGED" },
	{ 63,	"SZEKESFEEVAR" },
	{ 63,	"SZOLNOK" },
	{ 63,	"TATABANYA" },
	{ 63,	"VESZPREM" },
	{ 64,	"MADRID" },
	{ 65,	"BILBAO" },
	{ 66,	"CATANIA" },
	{ 66,	"COSENZA" },
	{ 66,	"MESSINA" },
	{ 66,	"PALERMO" },
	{ 66,	"REGGIO CALABRIA" },
	{ 67,	"IBIZA" },
	{ 67,	"MAHON" },
	{ 67,	"PALMA DE MALLORCA" },
	{ 68,	"VALENCIA" },
	{ 69,	"BARCELONA" },
	{ 69,	"FIGUERES" },
	{ 69,	"GIRONA" },
	{ 69,	"LLORET DE MAR" },
	{ 70,	"ANDORRA LA VELLA" },
	{ 71,	"SEVILLA" },
	{ 72,	"LISBOA" },
	{ 73,	"AJACCIO" },
	{ 73,	"BASTIA" },
	{ 73,	"CAGLIARI" },
	{ 73,	"SASSARI" },
	{ 74,	"GIJON" },
	{ 75,	"CORK" },
	{ 75,	"GALWAY" },
	{ 75,	"LIMERICK" },
	{ 76,	"BELFAST" },
	{ 76,	"DUBLIN" },
	{ 77,	"ABERDEEN" },
	{ 77,	"EDINBURGH" },
	{ 77,	"GLASGOW" },
	{ 77,	"ISLE OF MAN" },
	{ 78,	"BERGEN" },
	{ 78,	"STAVANGER" },
	{ 79,	"TRONDHEIM" },
	{ 80,	"SUNDSVALL" },
	{ 81,	"GDANSK" },
	{ 81,	"OLSZTYN" },
	{ 81,	"SLUPSK" },
	{ 82,	"BIALYSTOK" },
	{ 82,	"BYDGOSZCZ" },
	{ 82,	"LODZ" },
	{ 82,	"LUBLIN" },
	{ 82,	"TORUN" },
	{ 82,	"WARSZAWA" },
	{ 83,	"BIELSKO" },
	{ 83,	"KATOWICE" },
	{ 83,	"KIELCE" },
	{ 83,	"KRAKOW" },
	{ 83,	"OPOLE" },
	{ 83,	"RZESZOW" },
	{ 83,	"ZAKOPANE" },
	{ 84,	"UMEA" },
	{ 85,	"FALUN" },
	{ 85,	"OESTERSUND" },
	{ 86,	"SAMEDAN" },
	{ 87,	"OSIJEK" },
	{ 87,	"ZAGREB" },
	{ 88,	"ZERMATT" },
	{ 89,	"SPLIT" },
	{ 24,	"Doerphof" },
	{ -1,	NULL }
};

void display_city(const char *search)
{
	int i;
	int found = 0;

	for (i = 0; city_list[i].name; i++) {
		if (strcasestr(city_list[i].name, search)) {
			found++;
			printf("City %s is located in region %d.\n", city_list[i].name, city_list[i].region);
		}
	}
	if (!found) {
		printf("No city found for '%s', try larger city.\n", search);
	}
}

