'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH DS2404 3  2006 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2404
\- EconoRAM time chip
.TP
.B DS2404S
\- Dual port memory plus time
.TP
.B DS1994
\- 4k plus time iButton
.TP
.B DS1427
\- Time iButton
.SH SYNOPSIS
Real time clock, 4kbit memory. 3-wire interface, too.
.P
.B 04.XXXXXXXXXXXX 
/
.B alarm
|
.B auto
|
.B cycle
|
.B date
|
.B delay
|
.B interval
|
.B memory
|
.B pages/page.[0-15|ALL]
|
.B readonly/[memory|clock|cycle|interval]
|
.B memory
|
.B pages/page.[0-15|ALL]
|
.B readonly/[memory|clock|cycle|interval]
|
.B running
|
.B set_alarm
|
.B start
|
.B trigger/[cycle,date,interval,udate,uinterval]
|
.B udate
|
.B uinterval
|
.so man3/standard_mini.3so
.P
.B 84.XXXXXXXXXXXX
/
.B alarm
|
.B auto
|
.B cycle
|
.B date
|
.B delay
|
.B interval
|
.B memory
|
.B pages/page.[0-15|ALL]
|
.B readonly/[memory|clock|cycle|interval]
|
.B running
|
.B set_alarm
|
.B start
|
.B trigger/[cycle,date,interval,udate,uinterval]
|
.B udate
|
.B uinterval
|
.B address
|
.B crc8
|
.B id
|
.B present
|
.B type
.SH FAMILY CODE
.TP
.I 04
DS2404 DS1994
.TP
.I 84
DS1427 DS2404S
.SH SPECIAL PROPERTIES
.SS alarm
.I read-write, unsigned integer (0-111)
.br
.I Alarm
state of the
.I DS2404 (3)
triggered by time or counter events. Reading the alarm state clears the alarm.
.br
The 
.I alarm
value is of the form CIR, where:
.TP
C
.I cycle 
counter alarm
.br
.I 0
no
.br
.I 1
yes
.TP
I
.I interval
timer alarm
.br
.I 0
no
.br
.I 1
yes
.TP
R
real-time clock alarm
.br
.I 0
no
.br
.I 1
yes
.SS auto
.I read-write, yes-no
.br
Flag for mode of 
.I interval
counter operation. 0=manual 1=auto
.br
See the 
.I datasheet
for details.
.SS date
.I read-write, ascii
.br
26 character date representation of the
.I udate
value. Increments once per second while
.I running
.br
Actual internal representation has higher precision.
.br
Cannot be altered if
.I readonly/clock
is set.
.br
Setting
.I date
to a null string will put the current system time.
.br
Accepted date formats are:
.br
  Sat[urday] March 12 12:23:59 2001
.br
  Apr[il] 4 9:34:56 2002
.br
  3/23/04 23:34:57
.br
  current locale setting (your system's format)
.SS delay
.I read-write, yes-no
.br
Flag for adding a delay to
.I cycle
counter. 0=short 1-long
.br
See the 
.I datasheet
under "IDEL" for details.
.SS interval
.I read-write, date
.br
Interval timer value, represented as a 
.I date
string. More typically will be used as
.I uinterval
to read the actual elapsed seconds.
.SS memory
.I read-write, binary
.br
512 bytes of memory. The
.I readonly/memory
flag prevents further change.
.SS pages/page.0 ... pages/page.15 pages/page.ALL
.I read-write, yes-no
.br
Memory is split into 16 pages of 32 bytes each. The
.I readonly/memory
flag prevents further change.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS readonly/[memory|clock|interval|cycle]
.I read-write, yes-no
.br
Permanently protect part of the chip's function from alteration.
.TP
.I readonly/memory
.I page.X
and
. I memory
.TP
.I readonly/clock
.I date
and
.I udate
.TP
.I readonly/interval
.I interval
.TP
.I readonly/cycle
.I cycle
.SS running
.I read-write, yes-no
.br
State of the clock. 0=off 1=running.
.SS set_alarm
.I read-write, unsigned integer (0-111)
.br
Which of the
.I alarm
triggers are enabled in the
.I DS2404 (3)
.br
The 
.I set_alarm
value is of the form CIR, where:
.TP
C
.I cycle 
counter alarm
.br
.I 0
no
.br
.I 1
yes
.TP
I
.I interval
timer alarm
.br
.I 0
no
.br
.I 1
yes
.TP
R
real-time clock alarm
.br
.I 0
no
.br
.I 1
yes
.SS start
.I read-write, yes-no
.br
Flag for starting the 
.I interval
counter operation if not in 
.I auto
mode. 0=stop 1=start
.br
See the 
.I datasheet
for details.
.SS trigger/[cycle,date,interval,udate,uinterval]
.I read-write,varies
.br
Target value that will
.I trigger
the 
.I alarm
if the corresponding
.I set_alarm
field is set.
.br
The format is the same as the similarly named field (i.e.
.I date
for
.I trigger/date
)
.SS udate
.I read-write, unsigned integer
.br
Time represented as a number.
.I udate
increments once per second, while
.I running
is on.
.br
Usually set to unix time standard: number of seconds since Jan 1, 1970. The
.I date
field will be the unix representation of
.I udate
and setting either will change the other.
.SS uinterval
.I read-write, unsigned interval
.br
Similar to the 
.I udate
field, except corresponds to the
.I interval
value.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None implemented.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1427 DS1994 DS2404 DS2404S
The
.B DS1427 (3), DS1994 (3), DS2404 (3),
and
.B DS2404S (3)
family of 1-wire devices includes clock functions, with timers, memory, counters and alarms. It is possible to write-protect regians of memory. Uses include software or hardware timing and control.
.P
.SS Chips
Both the
.B DS2404 (3)
and
.B DS2404S (3)
have 1-wire and 3-wire interfaces, which might be useful for transferring data between the 2 buses. They act as a passive slave to both buses. The
.B DS2404 (3)
and
.B DS2404S (3)
require an external source of power and an external crystal. They also offer a reset and 1HZ clock pin.
.P
.SS iButtons
Both the
.B DS1427
and
.B DS1994
offer the memory, alarms, and clock function in iButton format. Because the iButton is a complete sealed package, battery and crystal are internal. Everything is access via the 1-wire interface.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2404.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS2404S-C01.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS1994.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS1427.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
