/*
 * QT Client for X2GoKDrive
 * Copyright (C) 2018-2023 Oleksandr Shneyder <o.shneyder@phoca-gmbh.de>
 * Copyright (C) 2018-2023 phoca-GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#include <QLabel>
#include "screenidentifier.h"

ScreenIdentifier::ScreenIdentifier(QWidget* parent,  Qt::WindowFlags flags):QMainWindow(parent, flags)
{
    label=new QLabel("", this);
    QFont f=label->font();
    f.setBold(true);
    f.setPointSize(56);
    label->setFont(f);
    label->setAlignment(Qt::AlignCenter);
    setCentralWidget(label);
    label->setFrameStyle(QFrame::Box);
}

void ScreenIdentifier::setText(const QString& text)
{
    label->setText(text);
}
