package ONVIF::Analytics::Types::MetadataInput;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %MetadataConfig_of :ATTR(:get<MetadataConfig>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        MetadataConfig
        Extension

    ) ],
    {
        'MetadataConfig' => \%MetadataConfig_of,
        'Extension' => \%Extension_of,
    },
    {
        'MetadataConfig' => 'ONVIF::Analytics::Types::Config',
        'Extension' => 'ONVIF::Analytics::Types::MetadataInputExtension',
    },
    {

        'MetadataConfig' => 'MetadataConfig',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::MetadataInput

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MetadataInput from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * MetadataConfig


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::MetadataInput
   MetadataConfig =>  { # ONVIF::Analytics::Types::Config
     Parameters =>  { # ONVIF::Analytics::Types::ItemList
       SimpleItem => ,
       ElementItem =>  {
       },
       Extension =>  { # ONVIF::Analytics::Types::ItemListExtension
       },
     },
   },
   Extension =>  { # ONVIF::Analytics::Types::MetadataInputExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

