/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Dimension;
import java.util.Arrays;
import org.havi.ui.HScreenConfiguration;
import org.havi.ui.HScreenRectangle;
import org.videolan.Logger;

public abstract class HScreenConfigTemplate {
    public static final int REQUIRED = 1;
    public static final int PREFERRED = 2;
    public static final int DONT_CARE = 3;
    public static final int PREFERRED_NOT = 4;
    public static final int REQUIRED_NOT = 5;
    public static final int ZERO_BACKGROUND_IMPACT = 1;
    public static final int ZERO_GRAPHICS_IMPACT = 2;
    public static final int ZERO_VIDEO_IMPACT = 3;
    public static final int INTERLACED_DISPLAY = 4;
    public static final int FLICKER_FILTERING = 5;
    public static final int VIDEO_GRAPHICS_PIXEL_ALIGNED = 6;
    public static final int PIXEL_ASPECT_RATIO = 7;
    public static final int PIXEL_RESOLUTION = 8;
    public static final int SCREEN_RECTANGLE = 9;
    private Object[] objectArray = new Object[this.getPreferenceObjectCount()];
    private int[] priorityArray = new int[this.getPreferenceCount()];
    static int[][] defaultConfig = new int[][]{{1920, 1080, 16, 9}, {1280, 720, 16, 9}, {720, 480, 4, 3}, {720, 480, 16, 9}, {720, 576, 4, 3}, {720, 576, 16, 9}, {960, 540, 16, 9}};
    private static final Logger logger = Logger.getLogger(HScreenConfigTemplate.class.getName());

    HScreenConfigTemplate() {
        Arrays.fill(this.priorityArray, 3);
    }

    public void setPreference(int preference, int priority) {
        if (priority < 1 || priority > 5) {
            logger.error("invalid priority " + priority);
            throw new IllegalArgumentException("invalid priority");
        }
        int index = this.getPreferenceIndex(preference);
        if (index < 0) {
            logger.error("invalid preference " + preference);
            throw new IllegalArgumentException("invalid preference");
        }
        this.priorityArray[index] = priority;
    }

    public void setPreference(int preference, Object object, int priority) {
        if (priority < 1 || priority > 5) {
            logger.error("invalid priority " + priority);
            throw new IllegalArgumentException("invalid priority");
        }
        int index = this.getPreferenceObjectIndex(preference);
        if (index < 0) {
            logger.error("invalid preference " + preference);
            throw new IllegalArgumentException("invalid preference");
        }
        this.objectArray[index] = object;
        this.priorityArray[this.getPreferenceIndex((int)preference)] = priority;
    }

    public int getPreferencePriority(int preference) {
        int index = this.getPreferenceIndex(preference);
        if (index < 0) {
            logger.error("invalid preference " + preference);
            throw new IllegalArgumentException("invalid preference");
        }
        return this.priorityArray[this.getPreferenceIndex(preference)];
    }

    public Object getPreferenceObject(int preference) {
        int index = this.getPreferenceObjectIndex(preference);
        if (index < 0) {
            logger.error("invalid preference " + preference);
            throw new IllegalArgumentException("invalid preference");
        }
        return this.objectArray[this.getPreferenceObjectIndex(preference)];
    }

    protected int getPreferenceCount() {
        return 9;
    }

    protected int getPreferenceObjectCount() {
        return 4;
    }

    protected int getPreferenceIndex(int preference) {
        if (preference < 1 || preference > 9) {
            return -1;
        }
        return preference - 1;
    }

    protected int getPreferenceObjectIndex(int preference) {
        if (preference < 6 || preference > 9) {
            return -1;
        }
        return preference - 6;
    }

    protected boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    protected int matchPreference(int preference, boolean supported) {
        int Priority = this.getPreferencePriority(preference);
        if (Priority == 1) {
            if (!supported) {
                return -1;
            }
            return 1;
        }
        if (Priority == 5) {
            if (supported) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    protected int matchPreference(int preference, HScreenConfiguration hsc) {
        switch (preference) {
            case 4: {
                return this.matchPreference(4, hsc.getInterlaced());
            }
            case 5: {
                return this.matchPreference(5, hsc.getFlickerFilter());
            }
            case 7: {
                return this.matchPreference(7, this.equals(hsc.getPixelAspectRatio(), this.getPreferenceObject(7)));
            }
            case 8: {
                return this.matchPreference(8, this.equals(hsc.getPixelResolution(), this.getPreferenceObject(8)));
            }
            case 9: {
                return this.matchPreference(9, this.equals(hsc.getScreenArea(), this.getPreferenceObject(9)));
            }
        }
        return 0;
    }

    protected int match(HScreenConfiguration hsc) {
        int score = 0;
        int length = this.getPreferenceCount();
        for (int i = 0; i < length; ++i) {
            int s = this.matchPreference(i, hsc);
            if (s < 0) {
                return s;
            }
            score += s;
        }
        return score;
    }

    static void initDefaultConfigTemplate(HScreenConfigTemplate hsct, int index) {
        hsct.setPreference(7, new Dimension(defaultConfig[index][2], defaultConfig[index][3]), 1);
        hsct.setPreference(8, new Dimension(defaultConfig[index][0], defaultConfig[index][1]), 1);
        hsct.setPreference(9, new HScreenRectangle(0.0f, 0.0f, 1.0f, 1.0f), 1);
    }
}

